<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Document extends Model 
{

    protected $table = 'documents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Customer()
    {
        return $this->belongsTo('Customer');
    }

    public function Activities()
    {
        return $this->morphMany('Activity', 'object');
    }

}